@extends('layouts.app')

@section('title', __('Modules'))

@section('sidebar')
    @include('partials/sidebar_menu_toggle')
    @include('modules/sidebar_menu')
@endsection

@section('content')

    @include('partials/flash_messages')

    @if (count($installed_modules))
        <div class="section-heading" id="installed">
            {{ __('Installed Modules') }}

            <span class="section-heading-right">
                <a href="#" data-trigger="modal" data-modal-body="#deactivate_license_modal" data-modal-size="sm" data-modal-no-footer="true" data-modal-title="{{ __('Deactivate License') }}" data-modal-on-show="deactivateLicenseModal" class="small">{{ __('Deactivate License') }}</a> | 
                <a href="https://freescout.net/remind-license-keys/" target="_blank" class="small">{{ __('Remind License Keys') }}</a>
            </span>
        </div>

        @if ($updates_available)
            <div class="row-container margin-top">
                <div class="alert alert-warning">
                    {{ __('There are updates available') }}:
                    <ul id="new_versions_list">
                        @php
                            $new_v_counter = 0;
                        @endphp
                        @foreach ($installed_modules as $module)
                            @if (!empty($module['new_version']))
                                @php $new_v_counter++; @endphp
                                <li><a href="#module-{{ $module['alias'] }}" data-module-alias="{{ $module['alias'] }}">{{ $module['name']}} ({{ $module['new_version'] }})</a></li>
                            @endif
                        @endforeach
                    </ul>
                    @if ($new_v_counter)
                        <a href="" class="btn btn-default btn-sm update-all-trigger margin-top" data-loading-text="{{ __('Update Now') }} ({{ $new_v_counter }})…">{{ __('Update Now') }} ({{ $new_v_counter }})</a>
                    @endif
                </div>
            </div>
        @endif

        @if ($invalid_symlinks)
            <div class="row-container margin-top">
                @include('modules/partials/invalid_symlinks')
            </div>
        @endif

        <div class="row-container margin-top">
            @foreach ($installed_modules as $module)
                @include('modules/partials/module_card')
            @endforeach
        </div>
        <div class="clearfix"></div>
    @endif
    
    <div class="section-heading" id="directory">
        {{ __('Modules Directory') }}
        @if (!count($installed_modules))
            <a href="#" data-trigger="modal" data-modal-body="#deactivate_license_modal" data-modal-size="sm" data-modal-no-footer="true" data-modal-title="{{ __('Deactivate License') }}" data-modal-on-show="deactivateLicenseModal" class="small pull-right">{{ __('Deactivate License') }}</a>
        @endif
    </div>

    <div class="row-container margin-top">
        <p class="text-help margin-bottom col-xs-12 padding-0">
            {!! __('Want to be notified by email when new modules are released?') !!} <a href="{{ \Config::get('app.freescout_url') }}/subscribe/" target="_blank">{{ __('Subscribe') }}</a>
        </p>
        @foreach ($modules_directory as $module)
            @include('modules/partials/module_card')
        @endforeach
    </div>

    <div class="clearfix margin-bottom"></div>

    @if (count($third_party_modules))
        <div class="section-heading" id="third-party">
            {{ __('Third-Party Modules') }} <small>({{ count($third_party_modules) }})</small>
        </div>

        <div class="row-container margin-top">
            <a href="#third-party-container" data-toggle="collapse" class="btn btn-default">{{ __('Show') }} »</a>
        </div>

        <div class="row-container margin-top collapse" id="third-party-container">
            @foreach ($third_party_modules as $module)
                @include('modules/partials/module_card')
            @endforeach
        </div>
    @endif

    <div class="clearfix margin-bottom-30"></div>

    <div id="deactivate_license_modal" class="hidden">

        <div class="form-group">
            <select class="form-control deactivate-license-module">
                @foreach ($all_modules as $module_alias => $module_name)
                    <option value="{{ $module_alias }}">{{ App\Module::formatName($module_name) }}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <input type="text" class="form-control deactivate-license-key" placeholder="{{ __('License Key') }}" />
        </div>

        <div class="margin-top margin-bottom-5">
            <button class="btn btn-primary button-deactivate-license" data-loading-text="{{ __('Deactivate') }}…">{{ __('Deactivate') }}</button>
            <button class="btn btn-link" data-dismiss="modal">{{ __('Cancel') }}</button>
        </div>
    </div>
@endsection

@section('javascript')
    @parent
    initModulesList();
@endsection