<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Routes group config
    |--------------------------------------------------------------------------
    |
    | The default group settings for the elFinder routes.
    |
    */
    'route'          => [
        'prefix'     => trim(parse_url(env('APP_URL', ''), PHP_URL_PATH) ?: '', '/').'/translations',
        'middleware' => [
            'web',
            'auth',
            'roles',
        ],
        // todo: replace admin with superadmin
        'roles' => ['admin'],
    ],

    /*
     * Enable deletion of translations
     *
     * @type boolean
     */
    'delete_enabled' => true,

    /*
     * Exclude specific groups from Laravel Translation Manager.
     * This is useful if, for example, you want to avoid editing the official Laravel language files.
     *
     * @type array
     *
     *    array(
     *        'pagination',
     *        'reminders',
     *        'validation',
     *    )
     */
    'exclude_groups' => [
        'auth',
        'reminders',
        'pagination',
        'passwords',
        'validation',
        'installer_messages',
    ],

    /*
     * Regular expression may determine goup incorrectly, for example for 'e.g'
     */
    'incorrect_groups' => [
        'e',
    ],
    /*
     * Exclude specific languages from Laravel Translation Manager.
     *
     * @type array
     *
     *    array(
     *        'fr',
     *        'de',
     *    )
     */
    'exclude_langs'  => [],

    /*
     * Export translations with keys output alphabetically.
     */
    'sort_keys '     => true,

    'trans_functions' => [
        'trans',
        'trans_choice',
        'Lang::get',
        'Lang::choice',
        'Lang::trans',
        'Lang::transChoice',
        '@lang',
        '@choice',
        '__',
        '$trans.get',
    ],

];
